@ECHO OFF

SET LOOPCNT=0

:LOOP
if %LOOPCNT%==5 GOTO FTL_ERR
if %LOOPCNT%==4 set LOOPCNT=5
if %LOOPCNT%==3 set LOOPCNT=4
if %LOOPCNT%==2 set LOOPCNT=3
if %LOOPCNT%==1 set LOOPCNT=2
if %LOOPCNT%==0 set LOOPCNT=1

ECHO.
ECHO Loop Count: %LOOPCNT%
ECHO ***********************************************************************
ECHO Checking if have BCM image.
ECHO ***********************************************************************
sleep 1
ECHO.

ushdiag -u -ibm -sv

IF ERRORLEVEL 1 GOTO CHK_SBI

ECHO.
ECHO ***********************************************************************
ECHO There is a BCM image.
ECHO ***********************************************************************
ECHO.

:FL_SBI
ECHO.
ECHO ***********************************************************************
ECHO Going to flash SBI (~5 seconds).
ECHO WARNING! WARNING!   DO NOT REMOVE POWER   WARNING! WARNING!
ECHO ***********************************************************************
ECHO.

ushdiag -u -flsh ..\firmware\sbiC07.otp -o 0 -ibm -sv -rfw

IF ERRORLEVEL 15 IF NOT ERRORLEVEL 16 GOTO SBI_ERR
IF ERRORLEVEL 14 IF NOT ERRORLEVEL 15 GOTO AHP_ERR
IF ERRORLEVEL 11 IF NOT ERRORLEVEL 12 GOTO TPM_ERR
IF ERRORLEVEL 8 IF NOT ERRORLEVEL 9 GOTO SBI_FLD
IF ERRORLEVEL 1 GOTO FL_SBI_E

:SBI_FLD
ECHO.
ECHO ***********************************************************************
ECHO The flash SBI image has been updated.
ECHO ***********************************************************************
ECHO.
ECHO ***********************************************************************
ECHO Going to clear the USH SCD (~1 seconds).
ECHO ***********************************************************************
ECHO.

ushdiag -u -flsh ..\firmware\clearscd.bin -o 1ffc00 -ibm -sv -rfw

IF ERRORLEVEL 14 IF NOT ERRORLEVEL 15 GOTO AHP_ERR
IF ERRORLEVEL 11 IF NOT ERRORLEVEL 12 GOTO TPM_ERR
IF ERRORLEVEL 8 IF NOT ERRORLEVEL 9 GOTO SCD_CLD0
IF ERRORLEVEL 1 GOTO CSCD_ERR

:SCD_CLD0
ECHO ***********************************************************************
ECHO Going to clear f5d0 (~1 seconds).
ECHO ***********************************************************************
ECHO.

ushdiag -u -flsh ..\firmware\clr512.bin -o fd50 -ibm -sv -rfw

IF ERRORLEVEL 14 IF NOT ERRORLEVEL 15 GOTO AHP_ERR
IF ERRORLEVEL 11 IF NOT ERRORLEVEL 12 GOTO TPM_ERR
IF ERRORLEVEL 8 IF NOT ERRORLEVEL 9 GOTO SCD_CLD1
IF ERRORLEVEL 1 GOTO CSCD_ERR

:SCD_CLD1
ECHO.
ECHO ***********************************************************************
ECHO The USH SCD has been cleared.
ECHO ***********************************************************************
ECHO.
ECHO ***********************************************************************
ECHO Going to Reset to SBI.
ECHO ***********************************************************************
ECHO.

ushdiag -u -rsts -ibm -sv

IF ERRORLEVEL 14 IF NOT ERRORLEVEL 15 GOTO AHP_ERR
IF ERRORLEVEL 11 IF NOT ERRORLEVEL 12 GOTO TPM_ERR
IF ERRORLEVEL 8 IF NOT ERRORLEVEL 9 GOTO RST_OK
IF ERRORLEVEL 1 GOTO RST_ERR

:RST_OK
ECHO.
ECHO ***********************************************************************
ECHO Waiting 10 seconds for SBI to come up.
ECHO ***********************************************************************
ECHO.

sleep 10

ECHO.
ECHO ***********************************************************************
ECHO Check if SBI is loaded.
ECHO ***********************************************************************
ECHO.

ushdiag -u -mjr -ibm -sv

IF ERRORLEVEL 8 IF NOT ERRORLEVEL 9 GOTO SBI_OK
IF ERRORLEVEL 1 GOTO LOAD_SBI

:SBI_OK
ECHO.
ECHO ***********************************************************************
ECHO SBI is OK.
ECHO ***********************************************************************
ECHO.

SET FLOOPCNT=0

:FULOOP
if %FLOOPCNT%==3 GOTO FWUG_ERR
if %FLOOPCNT%==2 set FLOOPCNT=3
if %FLOOPCNT%==1 set FLOOPCNT=2
if %FLOOPCNT%==0 set FLOOPCNT=1

ECHO Firmware Upgrade Loop Count: %FLOOPCNT%
ECHO ***********************************************************************
ECHO Going to flash BCM image into the USH (~50 seconds).
ECHO ***********************************************************************
ECHO.

ushdiag -u -fw ..\firmware\bcmC07.otp -o 10000 -dly 10 -ibm -sv -rfw

IF ERRORLEVEL 11 IF NOT ERRORLEVEL 12 GOTO TPM_ERR
IF ERRORLEVEL 8 IF NOT ERRORLEVEL 9 GOTO BCM_OK
IF ERRORLEVEL 1 GOTO FULOOP

:BCM_OK
ECHO.
ECHO ***********************************************************************
ECHO The flash BCM image has been updated.
ECHO ***********************************************************************
ECHO.
ECHO ***********************************************************************
ECHO Going to Reset the USH.
ECHO ***********************************************************************
ECHO.

ushdiag -u -rst -ibm -sv

IF ERRORLEVEL 14 IF NOT ERRORLEVEL 15 GOTO AHP_ERR
IF ERRORLEVEL 11 IF NOT ERRORLEVEL 12 GOTO TPM_ERR
IF ERRORLEVEL 8 IF NOT ERRORLEVEL 9 GOTO RST1_OK
IF ERRORLEVEL 1 GOTO RST_ERR

:RST1_OK
ECHO.
ECHO ***********************************************************************
ECHO Waiting 10 seconds for BCM to come up.
ECHO ***********************************************************************
ECHO.

sleep 10

ECHO ***********************************************************************
ECHO Checking BCM image came up.
ECHO ***********************************************************************
ECHO.

ushdiag -u -ibm -sv

IF ERRORLEVEL 1 GOTO BCM_ERR

ECHO.
ECHO ***********************************************************************
ECHO There is a BCM image.
ECHO ***********************************************************************
ECHO.
ECHO ***********************************************************************
ECHO Going to flash PBA into the USH (~30 seconds).
ECHO ***********************************************************************
ECHO.

ushdiag -u -pba ..\firmware\pbaapp.bin -ibm -sv

IF ERRORLEVEL 10 IF NOT ERRORLEVEL 11 GOTO PBA_AUTH
IF ERRORLEVEL 1 GOTO PBA_ERR

ECHO.
ECHO ***********************************************************************
ECHO The PBA image has been updated.
ECHO ***********************************************************************
ECHO.
ECHO ***********************************************************************
ECHO Going to enable anti-hammering.
ECHO ***********************************************************************
ECHO.

ushdiag -u -ah -ibm -sv

IF ERRORLEVEL 1 GOTO AH_ERR

ECHO.
ECHO ***********************************************************************
ECHO Anti-hammering has been enabled.
ECHO ***********************************************************************
ECHO.
ECHO ***********************************************************************
ECHO Setting RFID Configuration
ECHO ***********************************************************************
ushdiag -u -sid -ibm
IF ERRORLEVEL 1 GOTO FAIL_SID

ECHO.
ECHO ***********************************************************************
ECHO Setting Contacted SmartCard Presense
ECHO ***********************************************************************
ushdiag -u -scp a -ibm
IF ERRORLEVEL 1 GOTO FAIL_SCP

ECHO ***********************************************************************
ECHO Going to Reset the USH again.
ECHO ***********************************************************************
ECHO.

ushdiag -u -rst -ibm -sv

IF ERRORLEVEL 14 IF NOT ERRORLEVEL 15 GOTO AHP_ERR
IF ERRORLEVEL 11 IF NOT ERRORLEVEL 12 GOTO TPM_ERR
IF ERRORLEVEL 8 IF NOT ERRORLEVEL 9 GOTO RST2_OK
IF ERRORLEVEL 1 GOTO RST_ERR

:RST2_OK
ECHO.
ECHO ***********************************************************************
ECHO Waiting 10 seconds for BCM to come up.
ECHO ***********************************************************************
ECHO.

sleep 10

ECHO.
ECHO ***********************************************************************
ECHO Checking BCM image came up again.
ECHO ***********************************************************************
ECHO.

ushdiag -u -ibm -sv

IF ERRORLEVEL 1 GOTO BCM_ERR

ECHO.
ECHO ***********************************************************************
ECHO There is a BCM image.
ECHO ***********************************************************************

ushdiag -u -mjr -ibm -sv
ECHO.
ECHO The USH Firmware and PBA image have been updated.
ECHO.

EXIT 0
errlvl 0
GOTO EXIT


REM***********************************************************************************
REM***********************************************************************************

:CHK_SBI
ECHO.
ECHO ***********************************************************************
ECHO Check if SBI is loaded.
ECHO ***********************************************************************
ECHO.

ushdiag -u -mjr -ibm -sv

IF ERRORLEVEL 8 IF NOT ERRORLEVEL 9 GOTO FL_SBI
IF ERRORLEVEL 1 GOTO LOAD_SBI
GOTO FL_SBI


REM***********************************************************************************
REM***********************************************************************************

:LOAD_SBI
ECHO.
ECHO ***********************************************************************
ECHO Going to load SBI (~5 seconds).
ECHO ***********************************************************************
ECHO.

ushdiag -u -f ..\firmware\sbiC07.otp -ibm -sv

ECHO.
ECHO ***********************************************************************
ECHO Waiting for 10 seconds for SBI to come up.
ECHO ***********************************************************************
ECHO.

sleep 10

ECHO.
ECHO ***********************************************************************
ECHO Going to flash SBI (~5 seconds).
ECHO WARNING! WARNING!   DO NOT REMOVE POWER   WARNING! WARNING!
ECHO ***********************************************************************
ECHO.

ushdiag -u -flsh ..\firmware\sbiC07.otp -o 0 -ibm -sv -rfw

IF ERRORLEVEL 15 IF NOT ERRORLEVEL 16 GOTO SBI_ERR
IF ERRORLEVEL 14 IF NOT ERRORLEVEL 15 GOTO AHP_ERR
IF ERRORLEVEL 11 IF NOT ERRORLEVEL 12 GOTO TPM_ERR
IF ERRORLEVEL 8 IF NOT ERRORLEVEL 9 GOTO LSBI_RST
IF ERRORLEVEL 1 GOTO FL_SBI_E

:LSBI_RST
ECHO.
ECHO ***********************************************************************
ECHO Going to Reset to USH.
ECHO ***********************************************************************
ECHO.

ushdiag -u -rst -ibm -sv

IF ERRORLEVEL 14 IF NOT ERRORLEVEL 15 GOTO AHP_ERR
IF ERRORLEVEL 11 IF NOT ERRORLEVEL 12 GOTO TPM_ERR
IF ERRORLEVEL 8 IF NOT ERRORLEVEL 9 GOTO SRST_OK
IF ERRORLEVEL 1 GOTO RST_ERR

:SRST_OK
ECHO.
ECHO ***********************************************************************
ECHO Waiting 10 seconds for BCM to come up.
ECHO ***********************************************************************
ECHO.

sleep 10

GOTO SBI_FLD


REM***********************************************************************************
REM***********************************************************************************

:AH_ERR
ECHO.
ECHO ***********************************************************************
ECHO Failed to enable Anti-hammering.
ECHO ***********************************************************************
ECHO.
sleep 1
GOTO LOOP

:FWUG_ERR
ECHO.
ECHO ***********************************************************************
ECHO Failed to load BCM image.
ECHO ***********************************************************************
ECHO.
sleep 1
GOTO LOOP

:PBA_ERR
ECHO.
ECHO ***********************************************************************
ECHO Failed to load PBA image.
ECHO ***********************************************************************
ECHO.
sleep 1
GOTO LOOP

:BCM_ERR
ECHO.
ECHO ***********************************************************************
ECHO Failed to boot to BCM.
ECHO ***********************************************************************
ECHO.
sleep 1
GOTO LOOP

:CSCD_ERR
ECHO.
ECHO ***********************************************************************
ECHO Error Clearing SCD.
ECHO ***********************************************************************
ECHO.
sleep 1
GOTO LOOP

:FL_SBI_E
ECHO.
ECHO ***********************************************************************
ECHO Error Flashing SBI.
ECHO ***********************************************************************
ECHO.
sleep 1
GOTO LOOP

:RST_ERR
ECHO.
ECHO ***********************************************************************
ECHO Could not reset USH.
ECHO Cycle power on the system and rerun batch file.
ECHO ***********************************************************************
ECHO.
EXIT 1
errlvl 1
GOTO EXIT

:PBA_AUTH
ECHO.
ECHO ***********************************************************************
ECHO Could not program PBA, authorization failure.
ECHO You must remove current CV ADMIN to update the PBA image.
ECHO Clear the CV ADMIN and rerun batch file.
ECHO ***********************************************************************
ECHO.
EXIT 1
errlvl 1
GOTO EXIT

:TPM_ERR
ECHO.
ECHO ***********************************************************************
ECHO Error: Can not update firmware, TPM is enabled.
ECHO You must enable TPM and deactivate TPM via BIOS.
ECHO Then rerun batch file.
ECHO ***********************************************************************
ECHO.
EXIT 1
errlvl 1
GOTO EXIT

:AHP_ERR
ECHO.
ECHO ***********************************************************************
ECHO Error: Anti-hammering protection activated.
ECHO Cycle power on the system and rerun batch file.
ECHO ***********************************************************************
ECHO.
EXIT 1
errlvl 1
GOTO EXIT

:SBI_ERR
ECHO.
ECHO ***********************************************************************
ECHO Error: Trying to load incorrect firmware file.
ECHO Verify that you are using the correct batch file.
ECHO ***********************************************************************
ECHO.
EXIT 1
errlvl 1
GOTO EXIT

:FAIL_SID
ECHO.
ECHO ***********************************************************************
ECHO Error: Failed to Set RFID Configuration
ECHO ***********************************************************************
ECHO.
EXIT 1
errlvl 1
GOTO EXIT

:FAIL_SCP
ECHO.
ECHO ***********************************************************************
ECHO Error: Failed to Set SmartCard Presense
ECHO ***********************************************************************
ECHO.
EXIT 1
errlvl 1
GOTO EXIT

:FTL_ERR
ECHO.
ECHO ***********************************************************************
ECHO FATAL ERROR!!!
ECHO Could not upgrade USH Firmware.
ECHO ***********************************************************************
ECHO.

REM IF ERRORLEVEL 1 SET ERRORSTR=Error
REM IF ERRORLEVEL 2 SET ERRORSTR=Invalid Parameter
REM IF ERRORLEVEL 3 SET ERRORSTR=Invalid File
REM IF ERRORLEVEL 4 SET ERRORSTR=Missing Parameter
REM IF ERRORLEVEL 5 SET ERRORSTR=USB Error
REM IF ERRORLEVEL 6 SET ERRORSTR=CV Error
REM IF ERRORLEVEL 7 SET ERRORSTR=Test Failed
REM IF ERRORLEVEL 8 SET ERRORSTR=No Firmware
REM IF ERRORLEVEL 9 SET ERRORSTR=TPM Error
REM ECHO ERROR: %ERRORSTR%
ECHO.
EXIT 2
errlvl 2

:EXIT
